"""Sublime Text language mapping."""

lang_map = {
    # 'name': (('mapping_alias',), ('tmLanguage_or_sublime-syntax file',))
    'actionscript': (('as', 'actionscript',), ('ActionScript/ActionScript',)),
    'applescript': (('applescript',), ('AppleScript/AppleScript',)),
    'asp': (('asp',), ('ASP/ASP',)),
    'bash': (('bash', 'sh', 'ksh', 'shell'), ('ShellScript/Shell-Unix-Generic',)),
    'batch': (('batch', 'bat', 'dosbatch', 'winbatch'), ('Batch File/Batch File',)),
    'c': (('c',), ('C++/C',)),
    'c++': (('c++', 'cpp'), ('C++/C++',)),
    'c#': (('csharp', 'c#'), ('C#/C#',)),
    'clojure': (('clojure', 'clj'), ('Clojure/Clojure',)),
    'cmake': (('cmake',), ('CMake/CMake',)),
    'css': (('css',), ('CSS/CSS',)),
    'd': (('d',), ('D/D',)),
    'diff': (('diff',), ('Diff/Diff',)),
    'erlang': (('erlang',), ('Erlang/Erlang',)),
    'go': (('go',), ('Go/Go',)),
    'groovy': (('groovy',), ('Groovy/Groovy',)),
    'haskell': (('haskell', 'hs'), ('Haskell/Haskell',)),
    'html': (('html',), ('HTML/HTML',)),
    'java': (('java',), ('Java/Java',)),
    'javascript': (('javascript', 'js'), ('JavaScript/JavaScript', 'JavaScriptNext - ES6 Syntax/JavaScriptNext')),
    'json': (('json',), ('JavaScript/JSON', 'JavaScriptNext - ES6 Syntax/JSON (JavaScriptNext)')),
    'jsp': (('jsp',), ('Java/Java Server Pages (JSP)',)),
    'less': (('less',), ('LESS/LESS', 'LessImproved/LESS')),
    'lisp': (('common-lisp', 'cl', 'lisp', 'emacs', 'elisp'), ('Lisp/Lisp',)),
    'lua': (('lua',), ('Lua/Lua',)),
    'markdown': (('markdown', 'md'), ('Markdown/Markdown',)),
    'makefile': (('makefile', 'make', 'mf', 'bsdmake'), ('Makefile/Makefile',)),
    'matlab': (('matlab', 'octave'), ('Matlab/Matlab',)),
    'objective-c': (('objective-c', 'objectivec', 'obj-c', 'objc'), ('Objective-C/Objective-C',)),
    'objective-c++': (('objective-c++', 'objectivec++', 'obj-c++', 'objc++'), ('Objective-C/Objective-C++',)),
    'ocaml': (('ocaml',), ('OCaml/OCaml',)),
    'pascal': (('delphi', 'pas', 'pascal', 'objectpascal'), ('Pascal/Pascal',)),
    'perl': (('perl', 'pl'), ('Perl/Perl', 'ModernPerl/ModernPerl')),
    'php': (('php', 'php3', 'php4', 'php5'), ('PHP/PHP',)),
    'python': (('python', 'py'), ('Python/Python', 'MagicPython/grammars/MagicPython')),
    's': (('splus', 's', 'r'), ('R/R',)),
    'sql': (('sql',), ('SQL/SQL',)),
    'tcl': (('tcl',), ('TCL/Tcl',)),
    'regex': (('regex', 'regexp'), ('Regular Expressions/RegExp',)),
    'railshtml': (('rhtml', 'html+erb', 'html+ruby'), ('Rails/HTML (Rails)',)),
    'railsjs': (('js+erb', 'javascript+erb', 'js+ruby', 'javascript+ruby'), ('Rails/JavaScript (Rails)',)),
    'rst': (('rst', 'rest', 'restructuredtext'), ('RestructuredText/reStructuredText',)),
    'ruby': (('rb', 'ruby'), ('Ruby/Ruby',)),
    'scala': (('scala',), ('Scala/Scala',)),
    'tex': (('tex', 'latex'), ('LaTeX/LaTeX',)),
    'text': (('text',), ('Text/Plain text',)),
    'textile': (('textile',), ('Textile/Textile',)),
    'typescript': (('typescript', 'ts'), ('TypeScript/TypeScript', 'TypeScriptSyntax/TypeScript')),
    'xml': (('xml',), ('XML/XML',)),
    'yaml': (('yaml',), ('YAML/YAML',))
}
